/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.PathAssembler;

public class Install {
    private IDownload download = new Download();
    private boolean alwaysDownload;
    private boolean alwaysUnpack;
    private PathAssembler pathAssembler;

    public Install(boolean alwaysDownload, boolean alwaysUnpack, IDownload download, PathAssembler pathAssembler) {
        this.alwaysDownload = alwaysDownload;
        this.alwaysUnpack = alwaysUnpack;
        this.download = download;
        this.pathAssembler = pathAssembler;
    }

    public File createDist(URI distributionUrl, String distBase, String distPath, String zipBase, String zipPath) throws Exception {
        File gradleHome = this.pathAssembler.gradleHome(distBase, distPath, distributionUrl);
        if (!this.alwaysDownload && !this.alwaysUnpack && gradleHome.isDirectory()) {
            return gradleHome;
        }
        File localZipFile = this.pathAssembler.distZip(zipBase, zipPath, distributionUrl);
        if (this.alwaysDownload || !localZipFile.exists()) {
            File tmpZipFile = new File(localZipFile.getParentFile(), localZipFile.getName() + ".part");
            tmpZipFile.delete();
            System.out.println("Downloading " + distributionUrl);
            this.download.download(distributionUrl, tmpZipFile);
            tmpZipFile.renameTo(localZipFile);
        }
        if (gradleHome.isDirectory()) {
            System.out.println("Deleting directory " + gradleHome.getAbsolutePath());
            this.deleteDir(gradleHome);
        }
        File distDest = gradleHome.getParentFile();
        System.out.println("Unzipping " + localZipFile.getAbsolutePath() + " to " + distDest.getAbsolutePath());
        this.unzip(localZipFile, distDest);
        if (!gradleHome.isDirectory()) {
            throw new RuntimeException(String.format("Gradle distribution '%s' does not contain expected directory '%s'.", distributionUrl, gradleHome.getName()));
        }
        this.setExecutablePermissions(gradleHome);
        return gradleHome;
    }

    private void setExecutablePermissions(File gradleHome) {
        if (this.isWindows()) {
            return;
        }
        File gradleCommand = new File(gradleHome, "bin/gradle");
        String errorMessage = null;
        try {
            ProcessBuilder pb = new ProcessBuilder("chmod", "755", gradleCommand.getCanonicalPath());
            Process p = pb.start();
            if (p.waitFor() == 0) {
                System.out.println("Set executable permissions for: " + gradleCommand.getAbsolutePath());
            } else {
                String line;
                BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
                errorMessage = "";
                while ((line = is.readLine()) != null) {
                    errorMessage = errorMessage + line + System.getProperty("line.separator");
                }
            }
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        catch (InterruptedException e) {
            errorMessage = e.getMessage();
        }
        if (errorMessage != null) {
            System.out.println("Could not set executable permissions for: " + gradleCommand.getAbsolutePath());
            System.out.println("Please do this manually if you want to use the Gradle UI.");
        }
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public void unzip(File zip, File dest) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                new File(dest, entry.getName()).mkdirs();
                continue;
            }
            this.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(new File(dest, entry.getName()))));
        }
        zipFile.close();
    }

    public void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

