/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.gradle.wrapper.GradleWrapperMain;

public class BootstrapMainStarter {
    public void start(String[] args, File gradleHome) throws Exception {
        boolean debug = GradleWrapperMain.isDebug();
        File gradleJar = this.findLauncherJar(gradleHome);
        if (debug) {
            System.out.println("gradleJar = " + gradleJar.getAbsolutePath());
        }
        URLClassLoader contextClassLoader = new URLClassLoader(new URL[]{gradleJar.toURI().toURL()});
        Thread.currentThread().setContextClassLoader(contextClassLoader);
        Class<?> mainClass = contextClassLoader.loadClass("org.gradle.launcher.GradleMain");
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{args});
    }

    private File findLauncherJar(File gradleHome) {
        for (File file : new File(gradleHome, "lib").listFiles()) {
            if (!file.getName().matches("gradle-launcher-.*\\.jar")) continue;
            return file;
        }
        throw new RuntimeException(String.format("Could not locate the Gradle launcher JAR in Gradle distribution '%s'.", gradleHome));
    }
}

